% % THIS FILE IS NOT SUPPOSED TO BE MODIFIED BY THE AUTHORS
% % If a bug in the template needs to be fixed, please information the 
% % conference organisation team!
\def\fileversion{2026.0}
\def\filedate{2025/08/20}

\NeedsTeXFormat{LaTeX2e}

\ProvidesClass{CEAS_EuroGNC_2026}[\filedate\space Version \fileversion\space by Nicolas Fezans]

\newif\if@final
\newif\if@draft
\DeclareOption{final}{\@finaltrue}
\DeclareOption{draft}{\@drafttrue}


\DeclareOption*{
  \PassOptionsToClass{\CurrentOption}{article}%
}
\ProcessOptions\relax
\LoadClass[12pt]{article}
\RequirePackage[a4paper,margin=2.0cm,left=1.75cm,right=1.75cm]{geometry}
\RequirePackage{setspace}
\singlespacing

\setlength{\parskip}{6pt}
\setlength{\parindent}{0.75cm}


\if@final
\fi
\if@draft
  \doublespacing
\fi


\RequirePackage{newtxtext,newtxmath} 

\RequirePackage[T1]{fontenc}
\RequirePackage[utf8]{inputenc}

\RequirePackage{bm}

\RequirePackage{wrapfig}

\RequirePackage{enumitem}
\setlist{labelindent=\parindent,leftmargin=*,nosep}
\setlist[enumerate]{label={\arabic*)}}



\RequirePackage[style]{abstract}
\renewcommand{\abstitlestyle}[1]{\noindent\bfseries\normalsize\emph{ABSTRACT}}
\renewcommand{\abstracttextfont}{\justifying\noindent\bfseries\normalsize\ignorespaces}
\setlength{\absleftindent}{0.0cm}
\setlength{\absrightindent}{0.0cm}


\newcommand{\papernumber}[1]{\newcommand{\thispapernumber}{#1}}
\newcommand{\thisconfyear}{2026}

\renewcommand{\maketitle}{%
  \vspace*{-\topskip}      % remove the initial space
  \begingroup
  \centering
  \hrule height \z@        % to avoid the insertion of lineskip glue
  {\vspace*{2cm}\LARGE\textbf\@title\par}
  \vskip\baselineskip
  \endgroup
  \if@draft
    \thispagestyle{empty}
  \fi
  \setcounter{footnote}{0}
}



\RequirePackage{fancyhdr,eso-pic,rotating,xcolor}
\definecolor{CEASdarkblue}{RGB}{15,114,181}
\definecolor{CEASlightblue}{RGB}{110,193,228}
\fancyhead[L]{\begin{small}\href{https://doi.org/10.82124/CEAS-GNC-\thisconfyear-\thispapernumber}{\color{CEASdarkblue}{doi:\,10.82124/CEAS-GNC-\thisconfyear-\thispapernumber}}\end{small}\\\vspace{1.8cm}}
\fancyhead[C]{\vspace{0.8cm}\ \\ \includegraphics[width=1.0\textwidth]{EuroGNC_logo_v4_with_year_and_orgs.pdf}}
\fancyhead[R]{\begin{small}\textbf{CEAS-GNC-\thisconfyear-\thispapernumber}\end{small}\\\vspace{1.8cm}}
\fancyfoot[C]{}

\pagestyle{plain}
\renewcommand{\headrulewidth}{0pt}
\renewcommand{\footrulewidth}{0pt}

\AddToShipoutPicture{\put(94,28){\rotatebox{0}{\scalebox{.53}{
Except where otherwise noted, content of this paper is licensed under }}}}

\AddToShipoutPicture{\put(94,20){\rotatebox{0}{\scalebox{.53}{
a \href{https://creativecommons.org/licenses/by/4.0/}{Creative Commons Attribution 4.0 International License}. 
}}}}


\AddToShipoutPicture{\put(328,32){\rotatebox{0}{\scalebox{.53}{
The reproduction and distribution with attribution of the entire paper or of individual}}}}
\AddToShipoutPicture{\put(328,24){\rotatebox{0}{\scalebox{.53}{
pages, in electronic or printed form, including any material under non-CC-BY 4.0}}}}
\AddToShipoutPicture{\put(328,16){\rotatebox{0}{\scalebox{.53}{
licenses is hereby granted by the authors and respective copyright owners.}}}}

\AddToShipoutPicture{
\put(40,19){
\rotatebox{0}{
\scalebox{.8}{
\href{https://creativecommons.org/licenses/by/4.0/}{\includegraphics[width=1.8cm]{cc-by.png}}
}}}}

\AddToShipoutPicture{\put(280,28){\rotatebox{0}{\begin{footnotesize}\thispapernumber\ -\ \thepage\end{footnotesize}}}}

\RequirePackage[largestsep]{titlesec}
\renewcommand{\thesection}{\arabic{section}}
\renewcommand{\thesubsection}{\thesection.\arabic{subsection}}
\renewcommand{\thesubsubsection}{\thesubsection.\arabic{subsubsection}}

\titleformat{\section}{\Large\bfseries\singlespacing}{\thesection\space\space}{0pt}{}[]
\titlespacing{\section}{0pt}{-4.5ex+18pt}{0pt}


\titleformat{\subsection}{\large\bfseries\singlespacing}{\thesubsection\space\space}{0pt}{}[]
\titlespacing{\subsection}{0pt}{-4.0ex+12pt}{0pt}

\titleformat{\subsubsection}{\large\itshape\singlespacing}{\thesubsubsection\space\space}{0pt}{}[]
\titlespacing{\subsubsection}{0pt}{-4.0ex+12pt}{0pt}

\titleformat{\paragraph}{\normalsize\singlespacing}{\theparagraph\space\space}{0pt}{}[]
\titlespacing{\paragraph}{0pt}{-4.0ex+9pt}{0pt}

\RequirePackage[hyphens]{url}
\RequirePackage[pdfborder={0 0 0}]{hyperref}
\RequirePackage{xcolor}
\RequirePackage[all]{nowidow}
\RequirePackage{soul}
\RequirePackage{orcidlink}
\RequirePackage{rorlink}
\RequirePackage[document]{ragged2e}


\RequirePackage[tableposition=top]{caption}
\renewcommand{\figurename}{Fig.}
\captionsetup*{font=small,labelfont=bf,textfont=bf,labelsep=quad}
\renewcommand{\arraystretch}{1.2}

\newcommand{\keywords}[1]{\noindent\begin{small}{\textbf{Keywords:}~#1}\end{small}}

\RequirePackage[indentfirst=false,font+=small,leftmargin=1.0cm,rightmargin=1.0cm,vskip=4pt]
{quoting}

\setlength{\abovedisplayskip}{\baselineskip}
\setlength{\belowdisplayskip}{\baselineskip}
\setlength{\abovedisplayshortskip}{\baselineskip}
\setlength{\belowdisplayshortskip}{\baselineskip}

\RequirePackage[sort&compress,numbers]{natbib}
\bibliographystyle{CEAS_EuroGNC_2026}
\renewcommand{\bibfont}{\small}


\RequirePackage{tabularx}

\newcommand{\preauthorlist}{
    \renewcommand{\arraystretch}{1.75}
    \tymax=.666\textwidth\tymin=0cm
    \begin{tabular}{r l}}

\newcommand{\postauthorlist}{
    \end{tabular}
    \renewcommand{\arraystretch}{1.0}}

\newcommand{\affiliation}[1]{&\begin{small}#1\end{small}}


\newenvironment{authorList}[1]{
  \renewcommand{\arraystretch}{1.50}
  \setlength{\tabcolsep}{.00\textwidth}\noindent
  \begin{tabular}{p{#1} p{4mm} p{\textwidth-4mm-#1}}
}
{
  \end{tabular}
  \renewcommand{\arraystretch}{1.0}
  \vskip\baselineskip
}
\newcommand{\addAuthor}[2]{\RaggedRight\textbf{\textcolor[rgb]{0.05,0.05,0.45}{#1}} & &  \textcolor[rgb]{0.15,0.15,0.35}{\begin{small}\RaggedRight#2\end{small}}\\}

\newcommand{\emailAddress}[1]{\textcolor{blue}{\href{mailto:#1}{#1}}}


